program ArrayIO;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  AnsiTo866 in 'AnsiTo866.pas';

// =========================================================
var TstArray : array [0..20] of double;  //  
    CmdChar  : char;                     //   

// =========================================================
//      
procedure ShowMenu();
begin
WriteLn;
WriteRus (' /COMMAND MENU:'); WriteLn;
WriteRus ('H - /Help'); WriteLn;
WriteRus ('W -   /Write to array'); WriteLn;
WriteRus ('S -  /Show array'); WriteLn;
WriteRus ('Q - /Quit'); WriteLn;
WriteLn;
end;

// =========================================================
//      
procedure ShowArray();
var Ind    : word;    //  
    StrInd : string;  //    
    StrArr : string;  //    
begin
   WriteLn;
   WriteRus ('   /SHOW ARRAY'); WriteLn;
   WriteRus ('Index' + #09 + 'Value'); WriteLn;
   for Ind:=Low(TstArray) to High(TstArray) do
   begin
      StrInd:=IntToStr(Ind);
      StrArr:=FloatToStr(TstArray[Ind]);
      WriteLn(StrInd + #09 + StrArr);
   end;
   WriteLn;
end;

// =========================================================
//      
// =========================================================
//        
function StrToIntArrayIndex (WStr : string; var WInt : integer) : boolean;
var BInt : integer;
begin
   Result:=False;      //  
   try
     BInt:= StrToInt(WStr);
     if (BInt >= Low(TstArray)) and (BInt <= High(TstArray))
     then begin
        WInt:=BInt;
        Result:=True;  //  
     end
     else begin
       WriteRus (#09 + '(  )/ERROR(Index out range)');
       WriteLn;
     end;
   except
       WriteRus (#09 + '(  )/ERROR(Index not numeral)');
       WriteLn;
   end;
end;

// =========================================================
//      double
function StrToFloatArrayValue (WStr : string; var WDouble : double) : boolean;
begin
   Result:=False;   //  
   try
     WDouble:= StrToFloat(WStr);
     Result:=True;  //  
   except
       WriteRus (#09 + '(  )/ERROR(Value not numeral)');
       WriteLn;
   end;
end;

// =========================================================
//       
procedure WriteToArray();
var StrInd : string;   //    
    StrVal : string;   //    
    Ind    : integer;  //   
    Val    : double;   //   
begin
    WriteLn;
    WriteLn  ('==========================================');
    WriteRus ('  /IMPUT ARRAY ELEMENT.');
    WriteLn;
    WriteRus ('  /Index range ('
             + IntToStr(Low(TstArray))
             + '..'
             + IntToStr(High(TstArray))
             + ')'
             );
    WriteLn;
    WriteLn  ('------------------------------------------');
    repeat
       WriteRus ('   /Imput INDEX : ');
       ReadLn(StrInd);
    until StrToIntArrayIndex(StrInd, Ind);
    repeat
       WriteRus (' /Imput VALUE : ');
       ReadLn(StrVal);
    until StrToFloatArrayValue (StrVal, Val);
    TstArray[Ind]:=Val;
    WriteLn  ('==========================================');
    WriteLn;

end;

// =========================================================
//   
// =========================================================
begin
  { TODO -oUser -cConsole Main : Insert code here }
// 
  WriteLn  ('==========================================');
  WriteRus (' -  '); WriteLn;
  WriteLn  ('==========================================');
  ShowMenu;
  repeat
    WriteRus (' /IMPUT COMMAND : ');
    ReadLn(CmdChar);
    CmdChar:=UpCase(CmdChar);
    case CmdChar of
    'H': begin ShowMenu(); end;
    'W': begin WriteToArray(); end;
    'S': begin ShowArray(); end;
    else begin
           WriteLn;
           WriteRus(#09 + '( )/ERROR(Unknown command)');
           WriteLn;
         end;
    end;
  until ('Q' = CmdChar);


end.
